define([
    'backbone',
    'text!modules/notifications/notification-list-item.html',
    'modules/notifications/notifications-radio',
],
function(Backbone, template, radio) {
    'use strict';

    return Backbone.Marionette.View.extend({
        tagName: 'li',
        class: 'ui-corner-all',
        template: template,
        events: {'click button': 'showDetails'},
        showDetails: function() {
            radio.trigger('notifications:show-details', this.model);
        },
    });
});
